/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client.util;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.api.ResettingSupplier;
import io.github.lukebemish.dynamic_asset_generator.client.palette.Palette;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public interface IPalettePlan {
    public NativeImage getBackground() throws IOException;

    public NativeImage getOverlay() throws IOException;

    public NativeImage getPaletted() throws IOException;

    public boolean includeBackground();

    public boolean stretchPaletted();

    public int extend();

    default public ResettingSupplier<InputStream> getStream(ResourceLocation rl) {
        return ResettingSupplier.of(() -> {
            try (NativeImage image = Palette.paletteCombinedImage(this);){
                if (image == null) return null;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(image.m_85121_());
                return byteArrayInputStream;
            }
            catch (IOException e) {
                DynamicAssetGenerator.LOGGER.error("Could not write buffered image to stream: {}...\n", (Object)rl, (Object)e);
            }
            return null;
        }, this);
    }

    public static ResettingSupplier<InputStream> supply(ResourceLocation rl, Supplier<IPalettePlan> plan_sup) {
        return ResettingSupplier.of(() -> {
            IPalettePlan planned = (IPalettePlan)plan_sup.get();
            try (NativeImage image = Palette.paletteCombinedImage(planned);){
                if (image == null) return null;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(image.m_85121_());
                return byteArrayInputStream;
            }
            catch (IOException e) {
                DynamicAssetGenerator.LOGGER.error("Could not write buffered image to stream: {}...\n", (Object)rl, (Object)e);
            }
            return null;
        }, plan_sup);
    }
}

